<?php
function also_read_pro_settings_menu() {
    add_options_page('Also Read Pro Settings', 'Also Read Pro', 'manage_options', 'also-read-pro-settings', 'also_read_pro_settings_page');
}
add_action('admin_menu', 'also_read_pro_settings_menu');

function also_read_pro_settings_page() {
    ?>
    <div class="wrap">
        <h1>Also Read Smart Box Pro Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('also_read_pro_settings_group');
            do_settings_sections('also-read-pro-settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function also_read_pro_register_settings() {
    register_setting('also_read_pro_settings_group', 'also_read_pro_settings');

    add_settings_section('main_section', 'Main Settings', null, 'also-read-pro-settings');

    add_settings_field('enable', 'Enable Also Read', 'also_read_pro_enable_cb', 'also-read-pro-settings', 'main_section');
    add_settings_field('number', 'Number of Posts', 'also_read_pro_number_cb', 'also-read-pro-settings', 'main_section');
    add_settings_field('paragraphs', 'Show After Paragraph(s)', 'also_read_pro_paragraphs_cb', 'also-read-pro-settings', 'main_section');
}
add_action('admin_init', 'also_read_pro_register_settings');

function also_read_pro_enable_cb() {
    $options = get_option('also_read_pro_settings');
    $checked = isset($options['enable']) ? 'checked' : '';
    echo "<input type='checkbox' name='also_read_pro_settings[enable]' value='1' $checked>";
}

function also_read_pro_number_cb() {
    $options = get_option('also_read_pro_settings');
    $val = isset($options['number']) ? intval($options['number']) : 1;
    echo "<input type='number' name='also_read_pro_settings[number]' value='$val' min='1' max='10'>";
}

function also_read_pro_paragraphs_cb() {
    $options = get_option('also_read_pro_settings');
    $val = isset($options['paragraphs']) ? esc_attr($options['paragraphs']) : '3';
    echo "<input type='text' name='also_read_pro_settings[paragraphs]' value='$val'>";
    echo "<p class='description'>Enter comma-separated paragraph numbers, e.g. 3,6,9</p>";
}
