<?php
function also_read_pro_display_box($content) {
    if (!is_single()) return $content;

    $options = get_option('also_read_pro_settings');
    if (empty($options['enable'])) return $content;

    $paragraphs = !empty($options['paragraphs']) ? array_map('intval', explode(',', $options['paragraphs'])) : [3];
    $number = isset($options['number']) ? intval($options['number']) : 1;

    $related_args = [
        'post__not_in' => [get_the_ID()],
        'posts_per_page' => $number,
        'ignore_sticky_posts' => 1,
    ];
    $related_query = new WP_Query($related_args);

    $box_html = '<div class="also-read-pro-box"><h3>Also Read</h3>';

    if ($related_query->have_posts()) {
        while ($related_query->have_posts()) {
            $related_query->the_post();
            $box_html .= '<div class="also-read-pro-item">';
            if (has_post_thumbnail()) {
                $box_html .= '<a href="' . get_permalink() . '">' . get_the_post_thumbnail(get_the_ID(), 'thumbnail') . '</a>';
            }
            $box_html .= '<a href="' . get_permalink() . '" class="also-read-pro-title">' . get_the_title() . '</a>';
            $box_html .= '</div>';
        }
        wp_reset_postdata();
    }
    $box_html .= '<div class="also-read-credit">By Subhash Yadav</div></div>';

    $content_paragraphs = explode('</p>', $content);
    foreach ($paragraphs as $i => $para_index) {
        if (isset($content_paragraphs[$para_index - 1])) {
            $content_paragraphs[$para_index - 1] .= $box_html;
        }
    }
    return implode('</p>', $content_paragraphs);
}
add_filter('the_content', 'also_read_pro_display_box');
